//
//  OPTextureManager.h
//  The Obfuscated Path
//
//  Created by ss2cire on 12/5/08.
//  Copyright 2008 GryphonClaw Software. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <OpenGL/gl.h>

@interface OPTextureManager : NSObject
{
	NSMutableDictionary *textures;
}
	
+ (OPTextureManager *)sharedManager;
	
- (GLuint)textureWithName:(NSString *)name;
	
//This method really shouldn't be called directly, as it doesn't
//check to see if the file specified at path exists.
//It should only be called from textureWithName: which actually
//does check to see if the file exists first.
- (GLuint)loadImageFromPath:(NSString *)fullPath fileName:(NSString *)name;
@end
